#include "g_local.h"
#include "file.h"
#include <stdio.h>


void fgetline (FILE* infile, char* buffer)
{
	int		i=0;
	char	ch;

	ch = fgetc(infile);

	while ( (ch != EOF) && (ch != '\n') && (i < MAX_STRING_LENGTH) )
	{
		buffer[i++] = ch;
		ch = fgetc(infile);
	}

	if ( (ch != '\n') && (ch != EOF) )	// Keep going to the eof
		ch = fgetc(infile);

	buffer[i] = '\0';
	
	return;

}


int proccess_line(char*	buffer)
{
	char* temp = NULL;

	// Make sure the line's not empty

	if (strlen(buffer) == 0 || buffer[0] == '\n') return COMMENT_LINE;

	// Check to see if this is a comment line
	if (buffer[0] == '/' && buffer[1] == '/')	return COMMENT_LINE;

	// Check if this is the custom map keyword
	temp = strstr(buffer, ADMIN_CODE_STRING);
	if (temp != NULL)	return ADMIN_CODE_KEYWORD;

	// Check if this is the custom map keyword
	temp = strstr(buffer, CUSTOM_MAP_STRING);
	if (temp != NULL)	return CUSTOM_MAP_KEYWORD;

	// Check if this is the map rotation keyword
	temp = strstr(buffer, MAP_ROTATION_STRING);
	if (temp != NULL)	return MAP_ROTATION_KEYWORD;

	// Check if this is the default rotation keyword
	temp = strstr(buffer, DEFAULT_MAP_STRING);
	if (temp != NULL)	return DEFAULT_MAP_KEYWORD;

	temp = strstr(buffer, DEFAULT_TEAMPLAY_STRING);
	if (temp != NULL)	return DEFAULT_TEAMPLAY_KEYWORD;

	temp = strstr(buffer, DEFAULT_DMFLAGS_STRING);
	if (temp != NULL)	return DEFAULT_DMFLAGS_KEYWORD;

	temp = strstr(buffer, DEFAULT_PASSWORD_STRING);
	if (temp != NULL)	return DEFAULT_PASSWORD_KEYWORD;

	temp = strstr(buffer, DEFAULT_MOTD_STRING);
	if (temp != NULL)	return DEFAULT_MOTD_KEYWORD;

	temp = strstr(buffer, DEFAULT_TIME_STRING);
	if (temp != NULL)	return DEFAULT_TIME_KEYWORD;

	temp = strstr(buffer, DEFAULT_FRAG_STRING);
	if (temp != NULL)	return DEFAULT_FRAG_KEYWORD;

	temp = strstr(buffer, DEFAULT_CASH_STRING);
	if (temp != NULL)	return DEFAULT_CASH_KEYWORD;

	temp = strstr(buffer, ALLOW_MAP_VOTING_STRING);
	if (temp != NULL)	return MAP_VOTING_KEYWORD;

	temp = strstr(buffer, BAN_NAME_STRING);
	if (temp != NULL)	return BAN_NAME_KEYWORD;

	temp = strstr(buffer, BAN_IP_STRING);
	if (temp != NULL)	return BAN_IP_KEYWORD;

	temp = strstr(buffer, SCOREBOARD_FIRST_STRING);
	if (temp != NULL)	return SCOREBOARD_FIRST_KEYWORD;

	temp = strstr(buffer, FPH_SCOREBOARD_STRING);
	if (temp != NULL)	return FPH_SCOREBOARD_KEYWORD;

	temp = strstr(buffer, DISABLE_ADMIN_STRING);
	if (temp != NULL)	return DISABLE_ADMIN_KEYWORD;

	return FOUND_STRING;

}

int proccess_ini_file()
{
	FILE*	infile;		// Config file to be opened
	int	status = OK;
	int	mode = -1;
	char	buffer[MAX_STRING_LENGTH];
	char	map[32], dummy[32];
	char	temp[32];
	char	filename[32];
	cvar_t	*game_dir;


	strcpy(default_map,"");
	strcpy(default_teamplay,"");
	strcpy(default_dmflags,"");
	strcpy(default_password,"");

	// Set number of custom/rotation maps to 0
	game.num_rmaps = 0;
	game.num_cmaps = 0;
	allow_map_voting = false;
	disable_admin_voting = false;
	scoreboard_first = false;
	num_custom_maps = 0;
	num_netnames = 0;
	num_ips = 0;

	// Open config file
	game_dir = gi.cvar("game", "", 0);
	Com_sprintf (filename, sizeof(filename), "%s\\comp.ini",game_dir->string);
	infile = fopen(filename, "r");
	if (infile == NULL)	return FILE_OPEN_ERROR;
	
	// Read first line of the file
	fgetline(infile, buffer);

	while (!feof(infile))	// while there's still stuff
	{
		switch (proccess_line(buffer))	// Determine what to do with the line, based offa what's in it
		{
		case ADMIN_CODE_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(admincode, map, 16);
			break;
		case COMMENT_LINE:	// do nothing
			break;
		case MAP_ROTATION_KEYWORD:	// add maps to map rotation
			mode = ADD_ROTATION;
			break;
		case DEFAULT_MOTD_KEYWORD:	// add MOTD line
			mode = ADD_MOTD_LINE;
			break;
		case FOUND_STRING:	// Found a string
			if (mode == ADD_CUSTOM)
				add_to_custom_maps(buffer);
			if (mode == ADD_MOTD_LINE)
				add_to_MOTD(buffer);
			break;
		case DEFAULT_MAP_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_map, map, 32);
			break;
		case DEFAULT_TEAMPLAY_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_teamplay, map, 16);
			break;
		case DEFAULT_DMFLAGS_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_dmflags, map, 16);
			break;
		case DEFAULT_PASSWORD_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_password, map, 16);
			break;
		case DEFAULT_TIME_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_timelimit, map, 16);
			break;
		case DEFAULT_CASH_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_cashlimit, map, 16);
			break;
		case DEFAULT_FRAG_KEYWORD:
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(default_fraglimit, map, 16);
			break;
		case CUSTOM_MAP_KEYWORD: // add maps to custom map list
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(custom_map_filename, map, 32);
			break;
		case MAP_VOTING_KEYWORD: 
			allow_map_voting = true;
			break;
		case BAN_NAME_KEYWORD: 
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(ban_name_filename, map, 32);
			break;
		case BAN_IP_KEYWORD: 
			sscanf(buffer, "%s %s", dummy, map);	// Quick ugly hack :)
			strncpy(ban_ip_filename, map, 32);
			break;
		case SCOREBOARD_FIRST_KEYWORD: 
			scoreboard_first = true;
			break;
		case FPH_SCOREBOARD_KEYWORD: 
			fph_scoreboard = true;
			break;
		case DISABLE_ADMIN_KEYWORD: 
			disable_admin_voting = true;
			break;


		
		default:	// wtf is this?
			gi.dprintf("Unhandled line!\n");
		}
		fgetline(infile, buffer);		// Retrieve next line from the input file
	}

	// close the ini file
	fclose(infile);

	Com_sprintf (filename, sizeof(filename), "%s\\%s",game_dir->string, ban_name_filename);
	infile = fopen(filename, "r");
	if (infile != NULL)	
	{
	// Read first line of the file
		fgetline(infile, buffer);
		num_netnames = 0;
		while (!feof(infile))	// while there's still stuff
		{
			if (strlen(buffer) == 0 || buffer[0] == '\n')
			{
				fgetline(infile, buffer);
				continue;
			}
		// Check to see if this is a comment line
			if (buffer[0] == '/' && buffer[1] == '/')
			{
				fgetline(infile, buffer);
				continue;
			}
			strncpy(netname[num_netnames].value,buffer,16);
			fgetline(infile, buffer);
			num_netnames++;
		}
		fclose(infile);
	}


	Com_sprintf (filename, sizeof(filename), "%s\\%s",game_dir->string, ban_ip_filename);
	infile = fopen(filename, "r");
	infile = fopen(temp, "r");
	if (infile != NULL)	
	{
	// Read first line of the file
		fgetline(infile, buffer);
		num_ips = 0;
		while (!feof(infile))	// while there's still stuff
		{
			if (strlen(buffer) == 0 || buffer[0] == '\n')
			{
				fgetline(infile, buffer);
				continue;
			}
		// Check to see if this is a comment line
			if (buffer[0] == '/' && buffer[1] == '/')
			{
				fgetline(infile, buffer);
				continue;
			}
			strncpy(ip[num_ips].value,buffer,16);
			fgetline(infile, buffer);
			num_ips++;
		}
		fclose(infile);
	}

	return OK;
}

int read_map_file()
{

	FILE*	infile;		// Config file to be opened
	char	buffer[MAX_STRING_LENGTH];
	char	map[32], rank[16];
	char	filename[32];
	cvar_t	*game_dir;

	game_dir = gi.cvar("game", "", 0);
	Com_sprintf (filename, sizeof(filename), "%s\\%s",game_dir->string, custom_map_filename);
	infile = fopen(filename, "r");
	if (infile == NULL)	return FILE_OPEN_ERROR;

	num_custom_maps = 0;

	// Read first line of the file
	fgetline(infile, buffer);
	while (!feof(infile))	// while there's still stuff
	{
		if (strlen(buffer) == 0 || buffer[0] == '\n')
		{
			fgetline(infile, buffer);
			continue;
		}
	// Check to see if this is a comment line
		if (buffer[0] == '/' && buffer[1] == '/')
		{
			fgetline(infile, buffer);
			continue;
		}

		sscanf(buffer, "%s %s", rank, map);	
		strncpy(custom_list[num_custom_maps].custom_map, map, 32);
		custom_list[num_custom_maps].rank = atoi(rank);
		total_rank += custom_list[num_custom_maps].rank;
		num_custom_maps++;
		fgetline(infile, buffer);
	}

	return OK;
}

void add_to_custom_maps(char*	buffer)
{
	strncpy(custom_list[game.num_cmaps].custom_map, buffer, 16);
	game.num_cmaps++;
}

void add_to_MOTD(char*	buffer)
{
	strncpy(MOTD[game.num_MOTD_lines].textline, buffer, 99);
	game.num_MOTD_lines++;
}


// Test functions


int write_map_file()
{

	FILE*	outfile;
	char	temp[32];
	int		i;
	Com_sprintf (temp, sizeof(temp), "comp\\%s",custom_map_filename);
	outfile = fopen(temp, "w+");
	if (outfile == NULL)	return FILE_OPEN_ERROR;

	for (i=0; i< num_custom_maps; i++)	
		fprintf(outfile, "%d %s\n",custom_list[i].rank, custom_list[i].custom_map);

	fprintf(outfile, "\n");

	fclose(outfile);

	return OK;
}
